/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.FmtEditorMain;
import com.quantumdata.fmteditor.InstrumentSource;
import com.quantumdata.fmteditor.file.FmtFileType;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDInternalFrame;
import com.quantumdata.widgets.QDStdUI;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class FmtFrameBase
extends QDInternalFrame
implements InstrumentSource {
    private static Border g_actBorder = null;
    private static Border g_normBorder;
    private static int g_nextId;
    private FmtFileType m_fileType = FmtFileType.NONE;
    private StringBuilder title = new StringBuilder();

    public FmtFrameBase() {
        this.initName();
    }

    public FmtFrameBase(String string) {
        super(string);
        this.initName();
    }

    public FmtFrameBase(String string, boolean bl) {
        super(string, bl);
        this.initName();
    }

    public FmtFrameBase(String string, boolean bl, boolean bl2) {
        super(string, bl, bl2);
        this.initName();
    }

    public FmtFrameBase(String string, boolean bl, boolean bl2, boolean bl3) {
        super(string, bl, bl2, bl3);
        this.initName();
    }

    public FmtFrameBase(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(string, bl, bl2, bl3, bl4);
        this.initName();
    }

    private void initName() {
        this.setName("Frame" + ++g_nextId);
    }

    public void setAsActive(boolean bl) {
        if (g_actBorder == null) {
            g_actBorder = this.getBorder();
            g_normBorder = BorderFactory.createLineBorder(QDStdUI.getButtonLight(), 2);
        }
        if (bl) {
            this.setBorder(g_actBorder);
        } else {
            this.setBorder(g_normBorder);
        }
    }

    protected void setFileType(FmtFileType fmtFileType) {
        this.m_fileType = fmtFileType;
    }

    public FmtFileType getFileType() {
        return this.m_fileType;
    }

    public abstract String getTypeName();

    public abstract String getDataName();

    public String getRemoteDataName() {
        return this.getDataName();
    }

    public String getOptTitleText() {
        return "";
    }

    public abstract boolean isSaveable();

    public abstract boolean isLocalFile();

    public abstract boolean supportsRemoteFiles();

    public abstract boolean isModified();

    public abstract void markUnmodified();

    public void frameClosing() {
    }

    public abstract RemoteInstrument getInstrument();

    public abstract void setInstrument(RemoteInstrument var1);

    public boolean isConnected() {
        RemoteInstrument remoteInstrument = this.getInstrument();
        return remoteInstrument != null && remoteInstrument.isConnected();
    }

    public JComponent getInstrumentOwner() {
        return this;
    }

    public void setFrameTitle() {
        String string = this.getTypeName();
        if (!this.isSaveable()) {
            this.setTitle(string);
        } else {
            this.title.delete(0, this.title.length());
            String string2 = this.getDataName();
            this.title.append(string);
            this.title.append(": ");
            if (this.isModified()) {
                this.title.append(" * ");
            }
            if (string2.length() == 0) {
                this.title.append("<not named>");
            } else {
                this.title.append(string2);
            }
            this.title.append(this.getOptTitleText());
            this.setTitle(this.title.toString());
        }
    }

    public void setFrameTitle(String string) {
        this.setTitle(string);
        FmtEditorMain.instance().getWindowMenu().updateFrame(this);
    }

    static {
        g_nextId = 0;
    }
}

